#include <stdio.h>
#include <stdlib.h>

typedef struct {
    long long x, y;
} Point;

int cmp_sum(const void *a, const void *b) {
    Point *p = (Point *)a;
    Point *q = (Point *)b;
    if (p->x + p->y != q->x + q->y)
        return (p->x + p->y > q->x + q->y) ? 1 : -1;
    return (p->x > q->x) ? 1 : -1;
}

int cmp_diff(const void *a, const void *b) {
    Point *p = (Point *)a;
    Point *q = (Point *)b;
    if (p->x - p->y != q->x - q->y)
        return (p->x - p->y > q->x - q->y) ? 1 : -1;
    return (p->x > q->x) ? 1 : -1;
}

long long count(Point *p, int n, int type) {
    long long res = 0;
    for (int i = 0; i < n; ) {
        int j = i;
        while (j < n &&
              ((type == 0 && p[j].x + p[j].y == p[i].x + p[i].y) ||
               (type == 1 && p[j].x - p[j].y == p[i].x - p[i].y)))
            j++;

        for (int a = i; a < j; a++) {
            for (int b = a + 1; b < j; b++) {
                if (type == 0) {
                    if ((p[b].x > p[a].x && p[b].y < p[a].y) ||
                        (p[b].x < p[a].x && p[b].y > p[a].y))
                        res += 2;  
                } else {
                    if ((p[b].x > p[a].x && p[b].y > p[a].y) ||
                        (p[b].x < p[a].x && p[b].y < p[a].y))
                        res += 2;  
                }
            }
        }
        i = j;
    }
    return res;
}

int main() {
    int N;
    scanf("%d", &N);

    Point *p = malloc(N * sizeof(Point));
    for (int i = 0; i < N; i++)
        scanf("%lld %lld", &p[i].x, &p[i].y);

    qsort(p, N, sizeof(Point), cmp_sum);
    long long ans = count(p, N, 0);

    qsort(p, N, sizeof(Point), cmp_diff);
    ans += count(p, N, 1);

    printf("%lld\n", ans);
    free(p);
}